# 🎰 Baicaa - Aplicação de Sorteios com Créditos

Uma aplicação web completa para gestão de sorteios/roleta com sistema de créditos, desenvolvida em Node.js com interface em Português Angolano.

## 📋 Funcionalidades

### Página Principal (Pública)
- ✅ Roleta animada com cores preto e vermelho
- ✅ Ticker animado com números dos participantes (anonimizados)
- ✅ Contador regressivo para o próximo evento
- ✅ Exibição do prémio (valor em Kz ou item)
- ✅ Número de participantes
- ✅ Login para utilizadores
- ✅ Sons de rotação e vitória

### Página do Utilizador
- ✅ Saldo de créditos em Kwanza (Kz)
- ✅ Recarga via WhatsApp (500, 1000, 5000, 10000 Kz)
- ✅ Lista de eventos disponíveis
- ✅ Participação em eventos com créditos
- ✅ Opção de sair de eventos (reembolso)

### Painel de Administração
- ✅ Criar utilizadores com senha gerada automaticamente
- ✅ Enviar credenciais via WhatsApp
- ✅ Recarregar créditos de utilizadores
- ✅ Criar/Editar/Eliminar eventos
- ✅ Executar sorteio (seleção aleatória ponderada)
- ✅ Histórico de vencedores

## 🚀 Instalação

### Pré-requisitos
- Node.js 18+ 
- npm ou yarn

### Local Development (Yarn)
```bash
cd roulette-app
yarn install
yarn start
```

### Production/Server Deployment (NPM)
```bash
cd roulette-app
npm install
npm start
```

### Passos para Configuração

1. **Configurar variáveis de ambiente:**
Edite o arquivo `.env`:
```env
PORT=3000
SESSION_SECRET=sua_chave_secreta_segura
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin123
WHATSAPP_BUSINESS_NUMBER=244923456789
SPIN_DURATION_SECONDS=8
```

2. **Adicionar ficheiros de som:**
Adicione os ficheiros de som na pasta `public/sounds/`:
- `spin.mp3` - Som da roleta a girar
- `win.mp3` - Som de vitória/celebração

3. **Aceder à aplicação:**
Abra `http://localhost:3000` no navegador

### Notas de Compatibilidade

O aplicativo usa `sqlite3` em vez de `better-sqlite3` para melhor compatibilidade com ambientes de servidor mais antigos (como cPanel com versões GLIBC mais antigas).

#### cPanel Deployment
1. Faça upload de todos os ficheiros para o seu diretório cPanel
2. Execute `npm install` no terminal cPanel
3. Configure as variáveis de ambiente no cPanel
4. Inicie a aplicação com `npm start`

#### Resolução de Problemas
- **Erro "Cannot find module 'better-sqlite3'"**: Garanta que está usando `sqlite3` no package.json
- **Erro GLIBC**: O aplicativo está configurado para usar `sqlite3` que tem melhor compatibilidade
- **Erros de módulo**: Execute `npm install` ou `yarn install` para atualizar dependências

## 📱 Uso

### Como Administrador
1. Aceda a `http://localhost:3000`
2. Clique em "Entrar"
3. Use as credenciais:
   - Utilizador: `admin`
   - Senha: `admin123`
4. Será redirecionado para o painel de administração

### Criar Utilizadores
1. No painel admin, insira o número de telefone
2. Clique em "Criar Utilizador"
3. A senha será gerada automaticamente
4. Use os botões para copiar ou enviar via WhatsApp

### Criar Eventos
1. No painel admin, vá a "Eventos"
2. Preencha nome, data/hora, tipo e valor do prémio
3. Clique em "Criar Evento"

### Executar Sorteio
1. No painel admin, vá a "Eventos"
2. Clique em "Sortear" no evento desejado
3. O vencedor será selecionado aleatoriamente (ponderado pelos créditos apostados)

## 🗄️ Estrutura do Projeto

```
roulette-app/
├── server.js           # Servidor Express principal
├── package.json        # Dependências
├── .env               # Configurações
├── roulette.db        # Base de dados SQLite (criada automaticamente)
├── views/
│   ├── home.ejs       # Página principal
│   ├── user.ejs       # Página do utilizador
│   └── admin.ejs      # Painel de administração
└── public/
    └── sounds/
        ├── spin.mp3   # Som da roleta
        └── win.mp3    # Som de vitória
```

## 🔒 Segurança

- Senhas armazenadas com hash bcrypt
- Sessões seguras com express-session
- Validação de dados em todas as rotas
- Proteção de rotas admin

## 📞 Integração WhatsApp

A aplicação integra com WhatsApp Business para:
- Envio de credenciais a novos utilizadores
- Pedidos de recarga de créditos
- Reclamação de prémios

Configure o número do WhatsApp Business no arquivo `.env`.

## 🎨 Design

- Interface mobile-first
- Estilo neumórfico (soft UI)
- Cores: branco, cinza, vermelho, preto
- Fonte: Poppins
- Ícones: Font Awesome 6

## 📄 Licença

MIT License

---

Desenvolvido para o mercado Angolano 🇦🇴
