# cPanel Installation Instructions

## Option 1: Try Downgraded better-sqlite3 (Recommended First)

```bash
# Remove node_modules and package-lock.json
rm -rf node_modules package-lock.json

# Install with downgraded better-sqlite3
npm install

# If that fails, try with specific flags
npm install --build-from-source

# Or try with npm config
npm config set target_platform linux
npm config set target_arch x64
npm config set target_libc glibc
npm install
```

## Option 2: Use sqlite3 Alternative

If Option 1 fails, switch to sqlite3:

```bash
# Backup current package.json
cp package.json package.json.backup

# Use the sqlite3 version
cp package-sqlite3.json package.json
cp server-sqlite3.js server.js

# Clean install
rm -rf node_modules package-lock.json
npm install
```

## Option 3: Force Rebuild

```bash
# Force rebuild of native modules
npm rebuild --build-from-source

# Or specifically for better-sqlite3
npm rebuild better-sqlite3 --build-from-source
```

## Option 4: Use Yarn (Sometimes works better)

```bash
# Install yarn globally
npm install -g yarn

# Remove npm artifacts
rm -rf node_modules package-lock.json

# Install with yarn
yarn install

# If using yarn, start with:
yarn start
```

## Testing

After installation, test with:
```bash
node server.js
```

## If All Else Fail - Contact cPanel Support

The issue is GLIBC version incompatibility. Your server has GLIBC 2.18 but better-sqlite3 requires 2.29+. Ask cPanel support if they can:

1. Update GLIBC version
2. Provide a compatible Node.js environment
3. Enable containerization or Docker support

## Environment Variables (Add to .bashrc if needed)

```bash
export npm_config_target_platform=linux
export npm_config_target_arch=x64
export npm_config_target_libc=glibc
```
