// Middleware to check if user is authenticated
function isAuthenticated(req, res, next) {
  if (req.session.user) {
    return next();
  }
  req.flash('error', 'Por favor, faça login para continuar.');
  res.redirect('/');
}

// Middleware to check if user is admin
function isAdmin(req, res, next) {
  if (req.session.user && req.session.user.is_admin) {
    return next();
  }
  req.flash('error', 'Acesso não autorizado.');
  res.redirect('/');
}

// Middleware to check if user is NOT admin (regular user only)
function isRegularUser(req, res, next) {
  if (req.session.user && !req.session.user.is_admin) {
    return next();
  }
  if (req.session.user && req.session.user.is_admin) {
    return res.redirect('/admin');
  }
  req.flash('error', 'Por favor, faça login para continuar.');
  res.redirect('/');
}

module.exports = {
  isAuthenticated,
  isAdmin,
  isRegularUser
};
