const express = require('express');
const router = express.Router();
const { userOps } = require('../config/database');

// Login POST
router.post('/login', (req, res) => {
  const rawPhoneNumber = req.body?.phone_number;
  const password = req.body?.password;
  const phone_number = String(rawPhoneNumber || '').trim().replace(/\s+/g, '');
  const adminUsername = String(process.env.ADMIN_USERNAME || 'admin').trim().replace(/\s+/g, '');

  // Check for admin login
  if (phone_number === adminUsername || phone_number === 'admin') {
    userOps.findByPhone(phone_number, (err, admin) => {
      if (err || !admin) {
        // Try alternative admin usernames
        userOps.findByPhone(adminUsername, (err2, admin2) => {
          if (err2 || !admin2) {
            userOps.findByPhone('admin', (err3, admin3) => {
              const admin = admin || admin2 || admin3;
              if (admin && admin.is_admin && userOps.verifyPassword(admin, password)) {
                req.session.user = {
                  id: admin.id,
                  phone_number: admin.phone_number,
                  credits_balance: admin.credits_balance,
                  is_admin: true
                };
                req.flash('success', 'Bem-vindo, Administrador!');
                return res.redirect('/admin');
              }
              req.flash('error', 'Credenciais inválidas.');
              return res.redirect('/');
            });
          } else if (admin2 && admin2.is_admin && userOps.verifyPassword(admin2, password)) {
            req.session.user = {
              id: admin2.id,
              phone_number: admin2.phone_number,
              credits_balance: admin2.credits_balance,
              is_admin: true
            };
            req.flash('success', 'Bem-vindo, Administrador!');
            return res.redirect('/admin');
          } else {
            req.flash('error', 'Credenciais inválidas.');
            return res.redirect('/');
          }
        });
      } else if (admin && admin.is_admin && userOps.verifyPassword(admin, password)) {
        req.session.user = {
          id: admin.id,
          phone_number: admin.phone_number,
          credits_balance: admin.credits_balance,
          is_admin: true
        };
        req.flash('success', 'Bem-vindo, Administrador!');
        return res.redirect('/admin');
      } else {
        req.flash('error', 'Credenciais inválidas.');
        return res.redirect('/');
      }
    });
    return;
  }

  // Regular user login
  userOps.findByPhone(phone_number, (err, user) => {
    if (err || !user) {
      req.flash('error', 'Número de telefone não encontrado.');
      return res.redirect('/');
    }

    if (!userOps.verifyPassword(user, password)) {
      req.flash('error', 'Senha incorreta.');
      return res.redirect('/');
    }

    req.session.user = {
      id: user.id,
      phone_number: user.phone_number,
      credits_balance: user.credits_balance,
      is_admin: false
    };

    req.flash('success', 'Bem-vindo!');
    res.redirect('/user');
  });
});

// Logout
router.get('/logout', (req, res) => {
  req.session.destroy((err) => {
    if (err) {
      console.error('Error destroying session:', err);
    }
    res.redirect('/');
  });
});

// Admin login page
router.get('/admin-login', (req, res) => {
  if (req.session.user && req.session.user.is_admin) {
    return res.redirect('/admin');
  }
  res.render('admin-login', { title: 'Login Administrador' });
});

// Admin login POST
router.post('/admin-login', (req, res) => {
  const { username, password } = req.body;
  const normalizedUsername = String(username || '').trim().replace(/\s+/g, '');
  const adminUsername = String(process.env.ADMIN_USERNAME || 'admin').trim().replace(/\s+/g, '');

  if (normalizedUsername === adminUsername || normalizedUsername === 'admin') {
    userOps.findByPhone(normalizedUsername, (err, admin) => {
      if (err || !admin) {
        // Try alternative admin usernames
        userOps.findByPhone(adminUsername, (err2, admin2) => {
          if (err2 || !admin2) {
            userOps.findByPhone('admin', (err3, admin3) => {
              const admin = admin || admin2 || admin3;
              if (admin && admin.is_admin && userOps.verifyPassword(admin, password)) {
                req.session.user = {
                  id: admin.id,
                  phone_number: admin.phone_number,
                  credits_balance: admin.credits_balance,
                  is_admin: true
                };
                req.flash('success', 'Bem-vindo, Administrador!');
                return res.redirect('/admin');
              }
              req.flash('error', 'Credenciais inválidas.');
              return res.redirect('/auth/admin-login');
            });
          } else if (admin2 && admin2.is_admin && userOps.verifyPassword(admin2, password)) {
            req.session.user = {
              id: admin2.id,
              phone_number: admin2.phone_number,
              credits_balance: admin2.credits_balance,
              is_admin: true
            };
            req.flash('success', 'Bem-vindo, Administrador!');
            return res.redirect('/admin');
          } else {
            req.flash('error', 'Credenciais inválidas.');
            return res.redirect('/auth/admin-login');
          }
        });
      } else if (admin && admin.is_admin && userOps.verifyPassword(admin, password)) {
        req.session.user = {
          id: admin.id,
          phone_number: admin.phone_number,
          credits_balance: admin.credits_balance,
          is_admin: true
        };
        req.flash('success', 'Bem-vindo, Administrador!');
        return res.redirect('/admin');
      } else {
        req.flash('error', 'Credenciais inválidas.');
        return res.redirect('/auth/admin-login');
      }
    });
  } else {
    req.flash('error', 'Credenciais inválidas.');
    res.redirect('/auth/admin-login');
  }
});

// Registration is admin-only
router.get('/register', (req, res) => {
  if (req.session.user) {
    return res.redirect(req.session.user.is_admin ? '/admin' : '/user');
  }
  req.flash('error', 'Criação de conta disponível apenas pelo administrador.');
  res.redirect('/');
});

router.post('/register', (req, res) => {
  req.flash('error', 'Criação de conta disponível apenas pelo administrador.');
  res.redirect('/');
});

// Password reset is admin-only
router.get('/reset-password', (req, res) => {
  if (req.session.user) {
    return res.redirect(req.session.user.is_admin ? '/admin' : '/user');
  }
  req.flash('error', 'Reset de senha disponível apenas pelo administrador.');
  res.redirect('/');
});

router.post('/reset-password', (req, res) => {
  req.flash('error', 'Reset de senha disponível apenas pelo administrador.');
  res.redirect('/');
});

module.exports = router;
