const express = require('express');
const router = express.Router();
const { eventOps, participationOps, imaginaryOps } = require('../config/database');

// Home page - Public roulette view
router.get('/', (req, res) => {
  eventOps.getUpcoming(2, (err, events) => {
    if (err) {
      console.error('Error getting upcoming events:', err);
      return res.render('home', {
        title: 'Roleta Angol',
        events: [],
        currentEvent: null,
        nextEvent: null
      });
    }

    if (!events || events.length === 0) {
      return res.render('home', {
        title: 'Roleta Angol',
        events: [],
        currentEvent: null,
        nextEvent: null
      });
    }

    // Get participant counts for each event (real + imaginary)
    let processedEvents = 0;
    const eventsWithCounts = [];

    events.forEach((event, index) => {
      imaginaryOps.getAllParticipants(event.id, (err, allParticipants) => {
        if (err) {
          console.error('Error getting participants:', err);
          allParticipants = [];
        }

        eventsWithCounts[index] = {
          ...event,
          participantCount: allParticipants ? allParticipants.length : 0
        };

        processedEvents++;
        if (processedEvents === events.length) {
          res.render('home', {
            title: 'Roleta Angol',
            events: eventsWithCounts,
            currentEvent: eventsWithCounts[0] || null,
            nextEvent: eventsWithCounts[1] || null
          });
        }
      });
    });
  });
});

module.exports = router;
